/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.core.useragent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.core.useragent.InitialRequestManager;
import net.sourceforge.peers.sip.core.useragent.MessageInterceptor;
import net.sourceforge.peers.sip.core.useragent.MidDialogRequestManager;
import net.sourceforge.peers.sip.core.useragent.SipListener;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import net.sourceforge.peers.sip.transaction.ClientTransaction;
import net.sourceforge.peers.sip.transaction.InviteClientTransaction;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transactionuser.Dialog;
import net.sourceforge.peers.sip.transactionuser.DialogManager;
import net.sourceforge.peers.sip.transactionuser.DialogState;
import net.sourceforge.peers.sip.transport.SipMessage;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public class UAC {
    private InitialRequestManager initialRequestManager;
    private MidDialogRequestManager midDialogRequestManager;
    private String registerCallID;
    private String profileUri;
    private UserAgent userAgent;
    private TransactionManager transactionManager;
    private DialogManager dialogManager;
    private List<String> guiClosedCallIds;
    private Logger logger;

    public UAC(UserAgent userAgent, InitialRequestManager initialRequestManager, MidDialogRequestManager midDialogRequestManager, DialogManager dialogManager, TransactionManager transactionManager, TransportManager transportManager, Logger logger) {
        this.userAgent = userAgent;
        this.initialRequestManager = initialRequestManager;
        this.midDialogRequestManager = midDialogRequestManager;
        this.dialogManager = dialogManager;
        this.transactionManager = transactionManager;
        this.logger = logger;
        this.guiClosedCallIds = Collections.synchronizedList(new ArrayList());
        this.profileUri = "sip:" + userAgent.getUserpart() + '@' + userAgent.getDomain();
    }

    SipRequest register() throws SipUriSyntaxException {
        String domain = this.userAgent.getDomain();
        String requestUri = "sip:" + domain;
        SipListener sipListener = this.userAgent.getSipListener();
        this.profileUri = "sip:" + this.userAgent.getUserpart() + '@' + domain;
        this.registerCallID = Utils.generateCallID(this.userAgent.getConfig().getLocalInetAddress());
        SipRequest sipRequest = this.initialRequestManager.createInitialRequest(requestUri, "REGISTER", this.profileUri, this.registerCallID);
        if (sipListener != null) {
            sipListener.registering(sipRequest);
        }
        return sipRequest;
    }

    void unregister() throws SipUriSyntaxException {
        if (this.getInitialRequestManager().getRegisterHandler().isRegistered()) {
            String requestUri = "sip:" + this.userAgent.getDomain();
            MessageInterceptor messageInterceptor = new MessageInterceptor(){

                @Override
                public void postProcess(SipMessage sipMessage) {
                    ((UAC)UAC.this).initialRequestManager.registerHandler.unregister();
                    SipHeaders sipHeaders = sipMessage.getSipHeaders();
                    SipHeaderFieldValue contact = sipHeaders.get(new SipHeaderFieldName("Contact"));
                    contact.addParam(new SipHeaderParamName("expires"), "0");
                }
            };
            this.registerCallID = Utils.generateCallID(this.userAgent.getConfig().getLocalInetAddress());
            this.initialRequestManager.createInitialRequest(requestUri, "REGISTER", this.profileUri, this.registerCallID, null, messageInterceptor);
        }
    }

    SipRequest invite(String requestUri, String callId) throws SipUriSyntaxException {
        return this.initialRequestManager.createInitialRequest(requestUri, "INVITE", this.profileUri, callId);
    }

    private SipRequest getInviteWithAuth(String callId) {
        List<ClientTransaction> clientTransactions = this.transactionManager.getClientTransactionsFromCallId(callId, "INVITE");
        SipRequest sipRequestNoAuth = null;
        for (ClientTransaction clientTransaction : clientTransactions) {
            SipHeaderFieldName authorization;
            InviteClientTransaction inviteClientTransaction = (InviteClientTransaction)clientTransaction;
            SipRequest sipRequest = inviteClientTransaction.getRequest();
            SipHeaders sipHeaders = sipRequest.getSipHeaders();
            SipHeaderFieldValue value = sipHeaders.get(authorization = new SipHeaderFieldName("Authorization"));
            if (value == null) {
                SipHeaderFieldName proxyAuthorization = new SipHeaderFieldName("Proxy-Authorization");
                value = sipHeaders.get(proxyAuthorization);
            }
            if (value != null) {
                return sipRequest;
            }
            sipRequestNoAuth = sipRequest;
        }
        return sipRequestNoAuth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate(SipRequest sipRequest) {
        String callId = Utils.getMessageCallId(sipRequest);
        if (!this.guiClosedCallIds.contains(callId)) {
            this.guiClosedCallIds.add(callId);
        }
        Dialog dialog = this.dialogManager.getDialog(callId);
        SipRequest inviteWithAuth = this.getInviteWithAuth(callId);
        if (dialog != null) {
            SipRequest originatingRequest = inviteWithAuth != null ? inviteWithAuth : sipRequest;
            ClientTransaction clientTransaction = this.transactionManager.getClientTransaction(originatingRequest);
            if (clientTransaction != null) {
                ClientTransaction clientTransaction2 = clientTransaction;
                synchronized (clientTransaction2) {
                    DialogState dialogState = dialog.getState();
                    if (dialog.EARLY.equals(dialogState)) {
                        this.initialRequestManager.createCancel(inviteWithAuth, this.midDialogRequestManager, this.profileUri);
                    } else if (dialog.CONFIRMED.equals(dialogState)) {
                        this.midDialogRequestManager.generateMidDialogRequest(dialog, "BYE", null);
                        this.guiClosedCallIds.remove(callId);
                    }
                }
            } else {
                this.logger.debug("clientTransaction null");
                this.midDialogRequestManager.generateMidDialogRequest(dialog, "BYE", null);
                this.guiClosedCallIds.remove(callId);
            }
        } else {
            InviteClientTransaction inviteClientTransaction = (InviteClientTransaction)this.transactionManager.getClientTransaction(inviteWithAuth);
            if (inviteClientTransaction == null) {
                this.logger.error("cannot find invite client transaction for call " + callId);
            } else {
                int statusCode;
                SipResponse sipResponse = inviteClientTransaction.getLastResponse();
                if (sipResponse != null && (statusCode = sipResponse.getStatusCode()) < 200) {
                    this.initialRequestManager.createCancel(inviteWithAuth, this.midDialogRequestManager, this.profileUri);
                }
            }
        }
        this.userAgent.getMediaManager().stopSession();
    }

    public InitialRequestManager getInitialRequestManager() {
        return this.initialRequestManager;
    }

    public List<String> getGuiClosedCallIds() {
        return this.guiClosedCallIds;
    }
}

